//
//  ThirdViewController.m
//  ComAir5
//
//  Created by generalplus_sa1 on 10/22/14.
//  Copyright (c) 2014 generalplus_sa1. All rights reserved.
//

#import "ThirdViewController.h"
#import "ComAir5API.h"
#import <AVFoundation/AVFoundation.h>
#import <AudioToolbox/AudioToolbox.h>
//---------------------------------------------------------------
@interface ThirdViewController()
{
    
}
@property (retain, nonatomic) IBOutlet UILabel     *UILGain;
@property (retain, nonatomic) IBOutlet UISlider    *UIGainSlider;
@property (retain, nonatomic) IBOutlet UITextField *UITFFreq;
@property (retain, nonatomic) IBOutlet UITextField *UITFidf;
@property (retain, nonatomic) IBOutlet UITextField *UITFThreshold;

@end
//---------------------------------------------------------------
@implementation ThirdViewController
//-----------------------------------------------------------------
@synthesize UITFFreq,UITFidf,UITFThreshold,UILGain,UIGainSlider;
//-----------------------------------------------------------------
-(void)DisMissKeyboar
{
    [UITFFreq resignFirstResponder];
    [UITFidf resignFirstResponder];
    [UITFThreshold resignFirstResponder];
}
//-----------------------------------------------------------------
-(IBAction)PressSet:(id)sender
{
    int	i32Freq = [UITFFreq.text intValue];
    int i32iDf = [UITFidf.text intValue];
    int i32Threshold = [UITFThreshold.text intValue];

    SetComAir5Property(eComAir5PropertyTarget_Decode,eComAir5Property_CentralFreq,&i32Freq,sizeof(i32Freq));
    SetComAir5Property(eComAir5PropertyTarget_Encode,eComAir5Property_CentralFreq,&i32Freq,sizeof(i32Freq));
    
    SetComAir5Property(eComAir5PropertyTarget_Decode,eComAir5Property_iDfValue,&i32iDf,sizeof(i32iDf));
    SetComAir5Property(eComAir5PropertyTarget_Encode,eComAir5Property_iDfValue,&i32iDf,sizeof(i32iDf));
    
    SetComAir5Property(eComAir5PropertyTarget_Decode,eComAir5Property_Threshold,&i32Threshold,sizeof(i32Threshold));
    
    
    [self DisMissKeyboar];
}
//-----------------------------------------------------------------
-(IBAction)ChangeGain:(id)sender
{
    
    NSError* error;
    if ([AVAudioSession sharedInstance].isInputGainSettable)
    {
        [[AVAudioSession sharedInstance] setInputGain:UIGainSlider.value
                                                error:&error];
        
        UILGain.text = [NSString stringWithFormat:@"%.2f",UIGainSlider.value];
    }
    
}
//-----------------------------------------------------------------
- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view, typically from a nib.
    
    NSError* error;
    if ([AVAudioSession sharedInstance].isInputGainSettable)
    {
        
        UIGainSlider.value = [AVAudioSession sharedInstance].inputGain;
        [[AVAudioSession sharedInstance] setInputGain:UIGainSlider.value
                                                error:&error];
        
        UILGain.text = [NSString stringWithFormat:@"%.2f",[AVAudioSession sharedInstance].inputGain];
    }
    else
    {
        UIGainSlider.alpha = 0.5;
        UIGainSlider.enabled = false;
    }
    
}
//-----------------------------------------------------------------
- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}
//-----------------------------------------------------------------
- (BOOL)prefersStatusBarHidden {
    
    return true;
}
//-----------------------------------------------------------------
@end
